<?php

/**
 * INCLUDE ZONE
 * include is required for plugin detection
 * @author Logrise
 * */

include_once ABSPATH . 'wp-admin/includes/plugin.php';

/**
 * end include zone 
 * */
/*
 * Enqueue the parent stylesheet from Twenty Twenty One 
 * @author Logrise
 */
function enqueue_parent_styles()
{
    wp_enqueue_style(
        'child-style',
        get_stylesheet_uri(),
        array('twenty-twenty-one-style'),
        wp_get_theme()->get('Version') // this only works if you have Version in the style header
    );
}

add_action('wp_enqueue_scripts', 'enqueue_parent_styles');


/**
 * Detect plugin. For frontend only.
 * @author Logrise
 */
// check for plugin using plugin name -> In this case we check for gtranslate
if (is_plugin_active('gtranslate/gtranslate.php')) {
    /*
		 * The following function is to insert javascript on the footer that will remove the h1 tags added by the GTranslate plugin.
		 * */
    function wpb_hook_gtranslate_script()
    {
?>
        <script type="text/javascript">
            function loaded() {
                var el = document.getElementById("goog-gt-tt");
                setTimeout(() => {
                    var foo = document.querySelectorAll("#goog-gt-tt");
                    if (foo) foo.forEach(el => {
                        if (el) el.remove();
                    });
                }, 400)
            }
            document.addEventListener("DOMContentLoaded", loaded);
        </script>
<?php
    }
    add_action('wp_footer', 'wpb_hook_gtranslate_script');
}

/**
	 * End plugin detection
	 * */

    /*
    * 
    * Logrise Custom Javascript hook that adds javascript to footer. commented out by default. 
    * 
    * */

    function wpb_hook_javascript_footer() {
        ?>
            <script type="text/javascript">
                  window.addEventListener('load', function () {
					  jQuery(document).ready(function ($) {
						  jQuery(document).on('submit_success', function (event) {
							  if(dataLayer) {
								  dataLayer.push({
									  'event': 'Elementor Form Success',
									  'formName': event.target.name
								  });
							  } else {
								  console.warn('[ElementorFormSuccessHelper] There is no dataLayer handler.')
							  }
						  });
					  });
				  });
            </script>
        <?php
    }
    add_action('wp_footer', 'wpb_hook_javascript_footer');


//disable help button
add_action('admin_head', 'lg_disable_help_adminLink');
function lg_disable_help_adminLink() {
    if(is_admin()){
    echo '<style type="text/css">
            #contextual-help-link-wrap { display: none !important; }
          </style>';
    }
}

/*
//disable addplugins button
add_action('admin_footer', 'lg_disable_addPlugin_adminLink',PHP_INT_MAX );
function lg_disable_addPlugin_adminLink() {
    if(is_admin()){
    echo '<script>
            var els = document.querySelectorAll(\'a[href*="plugin-install.php"]\');
			for (var i = 0, l = els.length; i < l; i++) {
			var el = els[i];
			el.style.display = "none";
			}
          </script>';
    }
}
// Adiciona o codigo para esconder no menu
add_action('admin_menu', 'lg_disable_plugins_menu');
function lg_disable_plugins_menu() {
	remove_menu_page('plugins.php');
	remove_menu_page('themes.php');
	remove_menu_page('wpcode');
    remove_menu_page('options-general.php');
    remove_menu_page('postman');
	
   
}

*/

// Disable some endpoints for unauthenticated users
add_filter( 'rest_endpoints', 'disable_default_endpoints' );
function disable_default_endpoints( $endpoints ) {
    $endpoints_to_remove = array(
        '/oembed/1.0',
        '/wp/v2',
        '/wp/v2/media',
        '/wp/v2/types',
        '/wp/v2/statuses',
        '/wp/v2/taxonomies',
        '/wp/v2/tags',
        '/wp/v2/users',
        '/wp/v2/comments',
        '/wp/v2/settings',
        '/wp/v2/themes',
        '/wp/v2/blocks',
        '/wp/v2/oembed',
        '/wp/v2/posts',
        '/wp/v2/pages',
        '/wp/v2/block-renderer',
        '/wp/v2/search',
        '/wp/v2/categories'
    );

    if ( ! is_user_logged_in() ) {
        foreach ( $endpoints_to_remove as $rem_endpoint ) {
            // $base_endpoint = "/wp/v2/{$rem_endpoint}";
            foreach ( $endpoints as $maybe_endpoint => $object ) {
                if ( stripos( $maybe_endpoint, $rem_endpoint ) !== false ) {
                    unset( $endpoints[ $maybe_endpoint ] );
                }
            }
        }
    }
    return $endpoints;
}

/**
* Woo Specific Area
*/

add_filter( 'woocommerce_is_purchasable', '__return_false' );

function disable_cart() {
  if ( is_cart() ) {
    wp_redirect( home_url() );
    exit;
  }
}
add_action( 'template_redirect', 'disable_cart' );

/**
 * Regenerate elementor CSS and clear cache to avoid css malformation on updates
 * */
function regenerate_elementor_css_and_clear_cache($upgrader_object, $options) {
    // Check if Elementor is active
    if (is_plugin_active('elementor/elementor.php')) {
        // Regenerate Elementor CSS cache
        if (function_exists('exec')) {
            exec('wp elementor flush-css --regenerate');
        }
    }

    // Check if WP Fastest Cache is active
    if (is_plugin_active('wp-fastest-cache/wpFastestCache.php')) {
        if (function_exists('wpfc_clear_all_cache')) {
            wpfc_clear_all_cache(true);
        }
    }
}

// Hook into both core and plugin updates
add_action('upgrader_process_complete', 'regenerate_elementor_css_and_clear_cache', 10, 2);