<?php

/**
 *
 * @link              https://logrise.com
 * @since             0.8.0
 * @package           Wp_Logrise_Utility
 *
 * @wordpress-plugin
 * Plugin Name:       Logrise Utility
 * Plugin URI:        https://logrise.com
 * Description:       Logrise Utility is a custom WordPress plugin designed to unify essential functionalities across all Logrise-managed websites. It provides automation, optimization, and performance enhancements tailored to our shared stack.
 * Version:           0.8.0
 * Author:            Logrise Lda
 * Author URI:        https://logrise.com/
 * Text Domain:       wp-logrise-utility
 * Domain Path:       /languages
 */

// If this file is called directly, abort.
if (!defined('WPINC')) {
    die;
}

/**
 * Currently plugin version.
 * Start at version 0.1.0 and use SemVer - https://semver.org
 * Rename this for your plugin and update it as you release new versions.
 */
define('WP_LOGRISE_UTILITY_VERSION', '0.8.0');

/**
 * The code that runs during plugin activation.
 * This action is documented in includes/class-wp-logrise-utility-activator.php
 */
function activate_wp_logrise_utility(): void
{
    require_once plugin_dir_path(__FILE__) . 'includes/class-wp-logrise-utility-activator.php';
    Wp_Logrise_Utility_Activator::activate();
}

/**
 * The code that runs during plugin deactivation.
 * This action is documented in includes/class-wp-logrise-utility-deactivator.php
 */
function deactivate_wp_logrise_utility() : void
{
    require_once plugin_dir_path(__FILE__) . 'includes/class-wp-logrise-utility-deactivator.php';
    Wp_Logrise_Utility_Deactivator::deactivate();
}

register_activation_hook(__FILE__, 'activate_wp_logrise_utility');
register_deactivation_hook(__FILE__, 'deactivate_wp_logrise_utility');

/**
 * The core plugin class that is used to define internationalization,
 * admin-specific hooks, and public-facing site hooks.
 */
require plugin_dir_path(__FILE__) . 'includes/class-wp-logrise-utility.php';

/**
 * Begins execution of the plugin.
 *
 * Since everything within the plugin is registered via hooks,
 * then kicking off the plugin from this point in the file does
 * not affect the page life cycle.
 *
 * @since    0.1.0
 */
function run_wp_logrise_utility() : void
{

    $plugin = new Wp_Logrise_Utility();
    $plugin->run();

}

run_wp_logrise_utility();
