<?php

/**
 * Define the internationalization functionality
 *
 * Loads and defines the internationalization files for this plugin
 * so that it is ready for translation.
 *
 * @link       https://logrise.com
 * @since      0.1.0
 *
 * @package    Wp_Logrise_Utility
 * @subpackage Wp_Logrise_Utility/includes
 */

/**
 * Define the internationalization functionality.
 *
 * Loads and defines the internationalization files for this plugin
 * so that it is ready for translation.
 *
 * @since      0.1.0
 * @package    Wp_Logrise_Utility
 * @subpackage Wp_Logrise_Utility/includes
 * @author     Logrise Lda <support@logrise.com>
 */
class Wp_Logrise_Utility_i18n {


	/**
	 * Load the plugin text domain for translation.
	 *
	 * @since    0.1.0
	 */
	public function load_plugin_textdomain() {

		load_plugin_textdomain(
			'wp-logrise-utility',
			false,
			dirname( dirname( plugin_basename( __FILE__ ) ) ) . '/languages/'
		);

	}



}
