<?php
class Wp_Logrise_Utility_Cache_Manager
{

    private $plugin_name;
    private $version;

    public function __construct($plugin_name, $version)
    {
        $this->plugin_name = $plugin_name;
        $this->version = $version;
    }

    public function init(): void
    {
        add_action('upgrader_process_complete', array($this, 'regenerate_elementor_css_and_clear_cache'), 10, 2);
    }

    public function regenerate_elementor_css_and_clear_cache($upgrader_object, $options): void
    {
        // Skip if our own plugin is being updated
        if (isset($options['plugins']) && is_array($options['plugins'])) {
            foreach ($options['plugins'] as $plugin) {
                if (strpos($plugin, $this->plugin_name) !== false) {
                    return;
                }
            }
        }

        // Check if Elementor is active
        if (is_plugin_active('elementor/elementor.php')) {
            // Regenerate Elementor CSS cache
            if (function_exists('exec')) {
                exec('wp elementor flush-css --regenerate');
            }
        }

        // Check if WP Fastest Cache is active
        if (is_plugin_active('wp-fastest-cache/wpFastestCache.php')) {
            if (function_exists('wpfc_clear_all_cache')) {
                wpfc_clear_all_cache(true);
            }
        }
    }
}
